function [plotinfo,numgraphs] = filterByDeg(plotinfo,mindeg)
% this function goes through the list of graphs to be plotted and removes
% the graphs that do not match the degree sequence that the user entered

% declaration of constants
ZERO = 0;
ONE = 1;
TWO = 2;
THREE = 3;

% if there is no degree filter then exit
mindeg = str2num(mindeg);
if (mindeg == ZERO)
    numgraphs = length(plotinfo);
    return;
end

% counter variable for renaming matrices
newPlotnum = ONE;

C = cell(0,3);
for i=ONE:length(plotinfo)
    deg = plotinfo{i,THREE};
    deg = deg(1);
    deg = str2num(deg);
    if (deg >= mindeg)
        C(newPlotnum,ONE) = {plotinfo{i,ONE}};
        C(newPlotnum,TWO) = {plotinfo{i,TWO}};
        C(newPlotnum,THREE) = {plotinfo{i,THREE}};
        filename = ['grplot' num2str(i)];
        A = dlmread(filename,',');
        csvwrite(['grplot' num2str(newPlotnum)],A);
        newPlotnum = newPlotnum+ONE;
    end
end

numgraphs = size(C);
numgraphs = numgraphs(1);

plotinfo = C;