function verticesEdges()
% the VE function recieves a user query that specifies the number of
% vertices and the number of edges of the graphs that the user desires to
% display

% definition of constants
ZERO = 0;
ONE = 1;
TWO = 2;
THREE = 3;
FOUR = 4;
FIVE = 5;
SIX = 6;
EIGHT = 8;
NINE = 9;
TWENTY = 20;
FORTY = 40;
BK = '';

% definition of user input
fprintf('You can specify a variety of combinations of vertices and edges.\n\n');
fprintf('For example:\n\n');
fprintf('\tPlease enter the number of vertices: 6\n');
fprintf('\tPlease enter the number of edges: 3\n\n');
fprintf('The program displays graphs with 6 vertices & 3 edges\n\n');
fprintf('Another example:\n\n');
fprintf('\tPlease enter the number of vertices: 3 5 6:8\n');
fprintf('\tPlease enter the number of edges: 4\n\n');
fprintf('The program displays graphs with 3 vertices & 4 edges, 5 vertices & 4 edges\n');
fprintf('and 6 though 8 vertices & 4 edges\n');
fprintf('************************************************************************\n\n');

% input of user specified parameters
uservert = input('Please enter the number of vertices: ','s');
useredges = input('Please enter the number of edges: ','s');
mindeg = input('Please enter the minimum degree: ','s');

% if user doesn't specify the num of vertices, the default value (1<=n<=8) is
% substituted in its place, otherwise the string input is converted into a
% cell array
defaultFlag = ZERO;
if (strcmp(uservert,BK) == ONE)
    temp = THREE:EIGHT;
    uservert{1} = temp;
    defaultFlag = ONE;
else
    uservert = str2num2cell(uservert);
end

% if the user does not specify the num of edges, the default value
% (n*(n-1)/2) is substituted in its place, otherwise the user input is
% converted from a string to a cell array

if (strcmp(useredges,BK) == ONE)
    defaultFlag = ONE;
    for l=ONE:length(uservert)
        temp = uservert{l};
        temp = temp(length(temp));
        temp = temp*(temp-ONE)/TWO;
        temp = ONE:temp;
        useredges{1} = temp;
    end
else
    useredges = str2num2cell(useredges);
end

% if the user does not specify the minimum degree, the default value
% of zero is put in its place
if (strcmp(mindeg,BK) == ONE)
    mindeg = '0';
end

% if the number of vertex inputs is less than the number of edge inputs
% then the last value of vertex input is used to complete the list of
% vertices
if (length(uservert) < length(useredges))
    for l=length(uservert)+ONE:length(useredges)
        uservert{l} = uservert{length(uservert)};
    end
end

% if the number of edge inputs is less than the number of vertex
% inputs then the last value of edge input is used to complete the list of
% edges
if (length(useredges) < length(uservert))
    for l=length(useredges)+ONE:length(uservert)
        useredges{l} = useredges{length(useredges)};
    end
end

% determine the number of graphs by looping through each vertex/edge pair
% and extracting the number from the index file
numgraphs = 0;
metaindex = csvread('index',0,0,[0,0,5,0]);
dataindex = csvread('index',6,0);
for i=ONE:length(uservert)
    n = uservert{i};
    edges = useredges{i};
    for j=ONE:length(n)
        for k=ONE:length(edges)
            l=metaindex(n(j)-2);
            while (dataindex(l,ONE) == n(j))
                if (dataindex(l,TWO) == edges(k))
                    m = dataindex(l,FOUR);
                    numgraphs = numgraphs+m;
                end
                if (l+ONE > length(dataindex))
                    break;
                end
                l = l+ONE;
            end
        end
    end
end

% display the number of graphs to be generated
fprintf('There are ');
fprintf(num2str(numgraphs));
fprintf(' graph(s) that satisfy vertex and edge constraints...\n\n');

% create a cell array to store the relevant information for each graph that
% is saved
plotinfo = cell(numgraphs,3);
plotnum = ONE;
% outer loop; matches the range of vertices(n) with range of edges
for i=ONE:length(uservert)
    n = uservert{i};
    edges = useredges{i};
    
    % loop for each vertex in vertex - edge pair
    for j=ONE:length(n)
        filename = [num2str(n(j)) 'data'];
        
        % loop for each edge in vertex - edge pair
        for k=ONE:length(edges)
            if (edges(k) > (n(j)*(n(j)-1))/2)
                % chack to see if a default value is being used, if so
                % there is no need to display an error message
                if (defaultFlag == ZERO)
                    fprintf(['There are no graphs with ' num2str(n(j)) ' vertices and ' num2str(edges(k)) ' edges\n\n']);
                end 
                break;
            end
            
            % check the index matrix to find where to start reading the
            % data file and for how long
            l=metaindex(n(j)-2);
            while(dataindex(l,ONE) == n(j))
                if (dataindex(l,TWO) == edges(k))
                    startpos = dataindex(l,THREE);
                    m = dataindex(l,FOUR);
                end
                if (l+ONE > length(dataindex))
                    break;
                end
                l = l+ONE;
            end
            
            % read in the desired data from ndata file; uses dataindex
            % information to jump to the proper line and only read the
            % desired number of graphs
            graphdata = textread(filename,'%s',m,'delimiter','\n','headerlines',startpos);

            for l=ONE:length(graphdata)
                s = strtok(graphdata{l});
                numedges = s(FOUR:FIVE);
                plotinfo{plotnum} = numedges;
                graphnum = s(SIX:NINE);
                plotinfo{plotnum,TWO} = graphnum;
                    
                % make triangle for the adjacency matrix
                A = '';
                finish = NINE;
                for m=ONE:(n(j)-ONE)
                    start = finish+ONE;
                    finish = start+(n(j)-ONE-m);
                    A = strvcat(A,s(start:finish));
                end
                % call function to make adjacency matrix
                A = makeAdjMat(n(j),A);

                % write matrix data to a file
                csvwrite(['grplot' num2str(plotnum)],A);
                
                % add degree sequence to plotinfo
                degseq = degSeq(A,n(j));
                plotinfo{plotnum,THREE} = degseq;
                
                plotnum = plotnum+ONE;
            end
        end
        % free up memory used to generate graphs
        clear graphdata;
    end
end

% filter out graphs that have less than the minimum degree
temp = numgraphs;
[plotinfo,numgraphs] = filterByDeg(plotinfo,mindeg);

% if no graphs satisfy constraints from query
if (numgraphs == 0)
    fprintf('No graphs satisfy minimum degree constraint!\n');
    return;
end

% if some graphs are filtered out by minimum degree
if (str2num(mindeg) > 0 && temp ~= numgraphs)
    fprintf(num2str(temp-numgraphs));
    fprintf(' graph(s) do(es) not satisfy the minimum degree constraint,\n');
    fprintf(num2str(numgraphs));
    fprintf(' will be generated...\n');
end

SS = get(0,'ScreenSize');
figure('Position',SS);

% call graphpage function with initial command 's' for start
incommand = 's';
graphPage(plotinfo,plotnum,numgraphs,incommand);

delete grplot*;
close all hidden;