function graphPage(plotinfo,plotnum,numgraphs,incommand)
% this function graphs up to twenty graphs per figure; it calls the
% function changepage to handle the event of a key press by the user

% declaration of constants
ZERO = 0;
ONE = 1;
TWENTY = 20;
FORTY = 40;
Q = 'q';
S = 's';
N = 'n';
B = 'b';

% initial plot
while (strcmp(incommand,Q) == ZERO)
if (strcmp(incommand,S) == ONE)
    clf reset;
    plotnum = ONE;
elseif (strcmp(incommand,N) == ONE)
    clf reset;
    if (plotnum > numgraphs)
        plotnum = plotnum-mod(plotnum,TWENTY)+ONE;
    end
elseif (strcmp(incommand,B) == ONE)
    clf reset;
    if (plotnum-TWENTY <= ONE)
        plotnum = ONE;
    elseif (plotnum == numgraphs+ONE)
        plotnum = plotnum-mod(plotnum,TWENTY)-TWENTY+ONE;
    else
        plotnum = plotnum-mod(plotnum,TWENTY)-FORTY+ONE;
    end
else
    break;
end

for i=ONE:TWENTY
    if (plotnum <= numgraphs)
        graphPlot(plotinfo,plotnum,i);
        
        if (i == ONE)
            if (plotnum+TWENTY > numgraphs)
                text(-1,1,['Graphs ' num2str(plotnum) '-' num2str(numgraphs) ' out of '...
                    num2str(numgraphs)],'VerticalAlignment','bottom');
            else
                text(-1,1,['Graphs ' num2str(plotnum) '-' num2str(plotnum+TWENTY-ONE) ' out of '...
                    num2str(numgraphs)],'VerticalAlignment','bottom');
            end
        end
        
        plotnum = plotnum+ONE;
    else
        break;
    end
end
         
% if the page has less than 20 graphs, plot an empty graph in the bottom
% right corner to display instructions for keyboard commands in the figure
if (plotnum > numgraphs)
    A = 0;
    subplot(5,4,20); gplot(A,[0 1],'-ok');
    axis off;
    text(1,0,'Press: "n" to see the next page','VerticalAlignment','top',...
        'HorizontalAlignment','right');
    text(1,-0.1,'"b" to see the last page','VerticalAlignment','top',...
        'HorizontalAlignment','right');
    text(1,-0.2,'"q" to quit','VerticalAlignment','top','HorizontalAlignment','right');
else
    text(1,-1,'Press: "n" to see the next page','VerticalAlignment','top',...
        'HorizontalAlignment','right');
    text(1,-1.2,'"b" to see the last page','VerticalAlignment','top',...
        'HorizontalAlignment','right');
    text(1,-1.4,'"q" to quit','VerticalAlignment','top','HorizontalAlignment','right');
end

% wait until a button on the keyboard is pressed
wbp = waitforbuttonpress;
while (wbp == ZERO)
    wbp = waitforbuttonpress;
end

% receive the command from the keyboard
incommand = get(gcf,'CurrentCharacter');
end