function graphPlot(plotinfo,plotnum,i)
% this function takes in the number of graphs that the user wanted, and a
% cell array that has data corresponding to each graph and plots 20 per
% page

% declaration of constants
ONE = 1;
TWO = 2;
THREE = 3;
FOUR = 4;
FIVE = 5;
SIX = 6;
SEVEN = 7;
EIGHT = 8;

    % extract data from plotinfo and files
    numedges = plotinfo{plotnum};
    graphnum = plotinfo{plotnum,TWO};
    degseq = plotinfo{plotnum,THREE};
    filename = ['grplot' num2str(plotnum)];
    A = dlmread(filename,',');
    n = length(A);
    
    % create coordinate points
    index = 0:n-ONE;
    coords = [0.8*sin(((TWO*pi)/n)*index); 0.8*cos(((TWO*pi)/n)*index)];
    X = coords(1,1:n);
    Y = coords(2,1:n);
    coords = coords';
    
    % set up the plot axis
    subplot(FIVE,FOUR,i);
    axis([-ONE ONE -ONE ONE]);
    set(gca, 'FontSize', EIGHT);
    set(gca, 'xtick', []);
    set(gca, 'ytick', []);
    axis on;
    
    % plot n points
    for i=ONE:n
        line(X(i),Y(i),'Marker','o','MarkerEdgeColor','k','MarkerFaceColor','k')
    end
    
    % plot the edges of the graph
    for i=ONE:n-ONE
        for j=i+ONE:n
            if (A(i,j) == 1)
                x = [X(i) X(j)];
                y = [Y(i) Y(j)];
                line(x,y,'Color','k');
            end
        end
    end
    
    % label the graph; # vertices # edges and degseq
    text(-1,1,['V = 0' num2str(n);'E = ' numedges],'HorizontalAlignment','left',...
        'VerticalAlignment','top','FontSize',8);

         text(1,-1,num2str(plotnum),'HorizontalAlignment','right',...
             'VerticalAlignment','bottom','FontSize',8);

    text(1,1,degseq,'HorizontalAlignment','right','VerticalAlignment','top',...
        'FontSize',8);

    % label the points on the graph
    switch num2str(n)
    case '3'
    text(0,1,'1','VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    text(coords(TWO),coords(TWO,TWO)/1.1,'2',...
        'HorizontalAlignment','left',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(THREE),coords(THREE,TWO)/1.1,'3',...
        'HorizontalAlignment','right',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    case '4'
    text(0,1,'1','VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    text(coords(TWO)/.9,coords(TWO,TWO)/.9,'2',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(THREE)/.8,coords(THREE,TWO)/.8,'3',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(FOUR)/.9,coords(FOUR,TWO)/.9,'4',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    case '5'
    text(0,1,'1','VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    text(coords(TWO)/.9,coords(TWO,TWO)/.9,'2',...
        'HorizontalAlignment','left',...
        'VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    text(coords(THREE)/.8,coords(THREE,TWO)/.8,'3',...
        'HorizontalAlignment','right',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(FOUR)/.8,coords(FOUR,TWO)/.8,'4',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(FIVE)/.9,coords(FIVE,TWO)/.9,'5',...
        'HorizontalAlignment','left',...
        'VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    case '6'
    text(0,1,'1','VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    text(coords(TWO)/.9,coords(TWO,TWO)/.9,'2',...
        'HorizontalAlignment','right',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(THREE)/.9,coords(THREE,TWO)/.9,'3',...
        'HorizontalAlignment','left',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(FOUR)/.8,coords(FOUR,TWO)/.8,'4',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(FIVE)/.9,coords(FIVE,TWO)/.9,'5',...
        'HorizontalAlignment','right',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(SIX)/.9,coords(SIX,TWO)/.9,'6',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    case '7'         
    text(0,1,'1','VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    text(coords(TWO)/.9,coords(TWO,TWO)/.8,'2',...
        'HorizontalAlignment','left',...
        'VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    text(coords(THREE)/.9,coords(THREE,TWO)/.8,'3',...
        'HorizontalAlignment','left',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(FOUR)/.8,coords(FOUR,TWO)/.8,'4',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(FIVE)/.8,coords(FIVE,TWO)/.8,'5',...
        'HorizontalAlignment','right',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(SIX)/.9,coords(SIX,TWO)/.8,'6',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(SEVEN)/.9,coords(SEVEN,TWO)/.8,'7',...
        'VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    case '8'         
    text(0,1,'1','VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    text(coords(TWO)/.8,coords(2,TWO)/.8,'2',...
        'HorizontalAlignment','right',...
        'VerticalAlignment','top','FontSize',7,'FontWeight','bold');
    text(coords(THREE)/.9,coords(THREE,TWO)/.9,'3',...
        'HorizontalAlignment','right',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(FOUR)/.8,coords(FOUR,TWO)/.8,'4',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(FIVE)/.8,coords(FIVE,TWO)/.8,'5',...
        'HorizontalAlignment','right',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(SIX)/.8,coords(SIX,TWO)/.8,'6',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(SEVEN)/.9,coords(SEVEN,TWO)/.9,'7',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    text(coords(EIGHT)/.9,coords(EIGHT,TWO)/.9,'8',...
        'VerticalAlignment','bottom','FontSize',7,'FontWeight','bold');
    end