function A = makeAdjMat(n,s);
% makeadjmat(n,s) creates a n*n adjacency matrix from the string s

% declaration of constants
ONE = 1;
TWO = 2;

% create matrix
A = '';
    
% extract adjacency listing for each vertex
stringNum = n;
s = strvcat(s,'0');
temp = s(n);
    
% loop to add each completed adjacency sequence string into matrix A
for j=1:n-ONE
    for i=ONE:stringNum-ONE
        temp = strcat(s(stringNum-i,i),temp);
    end
    A = strvcat(temp,A);
    stringNum = stringNum-ONE;
    temp = '';
    for i = ONE:n-stringNum
        temp = strcat(temp,s(stringNum,i));
    end
    temp = strcat('0',temp);
end
A = strvcat(temp,A);

% convert the string cell array to a double cell array
A = cellstr(A);
for i=1:n
    temp = A{i};
    temp = temp';
    temp = str2num(temp);
    temp = temp';
    A{i} = temp;
end
    
% add each double to a final adjacency matrix
temp = A{ONE};
for i=TWO:n
    temp = [temp;A{i}];
end
A = temp;