open Ast;;
open Big_int;;
open List;;
open Precompiler.PCTypes;;
open Syntax_gen;;

exception Enumeration of string;;

let enumSpace:(exp VarMap.t) ref = ref (VarMap.empty);;
let enumVal:big_int ref = ref zero_big_int;;

let enumTDHandler ((name, ts):type_decl) (x:precompilerInfo): (tdResult * type_decl list * fun_decl list) =
  match ts with
      EnumSpec (valsList:(var * big_int option) list) ->
	enumVal := zero_big_int;
	iter (fun (name, (valOpt:big_int option)) ->
	       if VarMap.mem name !enumSpace then
		 raise (Enumeration "Duplicate enumeration value")
	       else (
		 match valOpt with
		     Some v ->
		       enumSpace := VarMap.add name (eint_bi v) !enumSpace;
		       enumVal := v
		   | None ->
		       enumVal := succ_big_int !enumVal;
		       enumSpace := VarMap.add name (eint_bi !enumVal) !enumSpace)) valsList;
	(TDChanged (name, AbbrevSpec (tvar "__Int")), [], [])
    | _ -> (TDUnchanged, [], []);;

let enumExpHandler (e:exp) (x:precompilerInfo): ehResult =
  match e.exp_raw with
      EVar v -> (
	try
	  ExpChanged (VarMap.find !v !enumSpace)
	with
	    Not_found -> ExpUnchanged)
    | _ -> ExpUnchanged;;
	  
	
