{
open Parse;;

(* Hack found in the XML mild parser - there should be a better way. *)
let currentString = ref "";;

let resetS = fun () -> currentString := "";;
let setS s = currentString := s;;
let appendS s = currentString := !currentString ^ s;;
let getS = fun () -> !currentString;;
 
}

let whitespace = [' ' '\r' '\n' '\t']
rule comment = parse
  "*/"    { () }
| "/*"    { comment lexbuf; comment lexbuf }
| '/'     { comment lexbuf }
| '*'     { comment lexbuf }
| [^'*''/']*  { comment lexbuf }
and antiquote = parse
  ":]"     { getS () }
| ":"      { appendS ":"; antiquote lexbuf }
| "[type:" { let s = getS () and s' = antiquote lexbuf in setS (s ^ "[type:" ^ s' ^ ":]"); antiquote lexbuf }
| "[expr:" { let s = getS () and s' = antiquote lexbuf in setS (s ^ "[expr:" ^ s' ^ ":]"); antiquote lexbuf }
| "[stmt:" { let s = getS () and s' = antiquote lexbuf in setS (s ^ "[stmt:" ^ s' ^ ":]"); antiquote lexbuf }
| [^ ':']* { appendS (Lexing.lexeme lexbuf); antiquote lexbuf }
and nativeBlock = parse
  [^ '}' '{']*    { appendS (Lexing.lexeme lexbuf); nativeBlock lexbuf } 
| '}'             { getS () }
| '{'             { let s = getS () and s' = resetS (); nativeBlock lexbuf in setS (s ^ "{" ^ s' ^ "}"); nativeBlock lexbuf }
and token = parse
  "auto"          { AUTO }
| "break"         { BREAK }
| "case"          { CASE }
| "char"          { CHAR }
| "const"         { CONST }
| "continue"      { CONTINUE }
| "default"       { DEFAULT }
| "do"            { DO }
| "double"        { DOUBLE }
| "else"          { ELSE }
| "enum"          { ENUM }
| "extern"        { EXTERN }
| "float"         { FLOAT }
| "for"           { FOR }
| "goto"          { GOTO }
| "heap"          { HEAP }
| "if"            { IF }
| "int"           { INT }
| "inline"        { INLINE }
| "long"          { LONG }
| "register"      { REGISTER }
| "return"        { RETURN }
| "short"         { SHORT }
| "signed"        { SIGNED }
| "sizeof"        { SIZEOF }
| "static"        { STATIC }
| "struct"        { STRUCT }
| "switch"        { SWITCH }
| "typedef"       { TYPEDEF }
| "union"         { UNION }
| "unsigned"      { UNSIGNED }
| "void"          { VOID }
| "volatile"      { VOLATILE }
| "while"         { WHILE }

| "bool"          { BOOL }
| "new"           { NEW }
| "true"          { CONSTBOOL (true) }
| "false"         { CONSTBOOL (false) }
| "null"          { NULL }
| "try"           { TRY }
| "catch"         { CATCH }
(*
| "readonly"      { READONLY }
| "subarray"      { SUBARRAY }

| "module"        { MODULE }
| "interface"     { INTERFACE }
*)
| "import"        { IMPORT }
| "exports"       { EXPORTS }
| "all"           { ALL }
(*
| "thread"        { THREAD }
| "spawn"         { SPAWN }
| "async"         { ASYNC }
*)
| "let"           { LET }
| "where"         { WHERE }
| "type"['0'-'9']+          { TYPE (let s = Lexing.lexeme lexbuf in (int_of_string (String.sub s 4 (String.length s - 4)))) }
| "type"          { TYPE Ast.wordsize }
(*
| "Bool"          { TBOOL }
| "S"['0'-'9']+   { SIZEDTINT (Ast.Signed, let s = Lexing.lexeme lexbuf in (int_of_string (String.sub s 1 (String.length s - 1)))) }
| "U"['0'-'9']+   { SIZEDTINT (Ast.Unsigned, let s = Lexing.lexeme lexbuf in (int_of_string (String.sub s 1 (String.length s - 1)))) }
*)
| "s"['0'-'9']+   { SIZEDINT (Ast.Signed, let s = Lexing.lexeme lexbuf in (int_of_string (String.sub s 1 (String.length s - 1)))) }
| "u"['0'-'9']+   { SIZEDINT (Ast.Unsigned, let s = Lexing.lexeme lexbuf in (int_of_string (String.sub s 1 (String.length s - 1)))) }
| "byte"          { BYTE }
| "all"           { ALL }
| "exists"        { EXISTS }
| "native" whitespace* "{" { resetS (); NATIVEBLOCK (nativeBlock lexbuf) }
| "native"        { NATIVE }
| "fun"           { FUN }
| "typefun"       { TYPEFUN }
| "rec"           { REC }
| "pack"          { PACK }
| "unpack"        { UNPACK }
| "limited"       { LIMITED }
| "limitany"      { LIMITANY }

| '_'*['A'-'Z']['A'-'Z''a'-'z''0'-'9''_']*  { UID (Lexing.lexeme lexbuf) }
| '_'*['a'-'z']['A'-'Z''a'-'z''0'-'9''_']*  { ID (Lexing.lexeme lexbuf) }
| ['0'-'9']+ { CONSTINT (Big_int.big_int_of_string (Lexing.lexeme lexbuf)) }

| '0''x'['A'-'Z''a'-'z''0'-'9']+ 
  { CONSTINT (Big_int.big_int_of_string (
              Int64.to_string (Int64.of_string (Lexing.lexeme lexbuf)))) }

| '"' ([^ '"''\n''\\'] | '\\' _)* '"' { STRING_LITERAL (Lexing.lexeme lexbuf) }

| "["             { LBRACKET }
| "]"             { RBRACKET }
| "("             { LPAREN }
| ")"             { RPAREN }
| "."             { DOT }
| "->"            { RARROW }
| "<-"            { LARROW }
| "++"            { PLUSPLUS }
| "--"            { MINUSMINUS }
| "&"             { AMPERSAND }
| "*"             { STAR }
| "+"             { PLUS }
| "-"             { MINUS }
| "~"             { TILDE }
| "!"             { BANG }
| "/"             { SLASH }
| "%"             { PERCENT }
| "<<"            { LTLT }
| ">>"            { GTGT }
| "<"             { LT }
| ">"             { GT }
| "<="            { LE }
| ">="            { GE }
| "=="            { EQUALSEQUALS }
| "!="            { NE }
| "^"             { CARET }
| "|"             { BAR }
| "&&"            { AMPERSANDAMPERSAND }
| "||"            { BARBAR }
| "?"             { QUESTION }
| ":"             { COLON }
| "="             { EQUALS }
| "*="            { STAREQUALS }
| "/="            { SLASHEQUALS }
| "%="            { PERCENTEQUALS }
| "+="            { PLUSEQUALS }
| "-="            { MINUSEQUALS }
| "<<="           { LTLTEQUALS }
| ">>="           { GTGTEQUALS }
| "&="            { AMPERSANDEQUALS }
| "^="            { CARETEQUALS }
| "|="            { BAREQUALS }
| ","             { COMMA }
| "{"             { LBRACE }
| "}"             { RBRACE }
| ";"             { SEMICOLON }
| "@"             { AT }
| "<=>"           { EQUIV }

| "[type:"        { resetS (); AQTYPE (antiquote lexbuf) }
| "[expr:"        { resetS (); AQEXPR (antiquote lexbuf) }
| "[stmt:"        { resetS (); AQSTMT (antiquote lexbuf) }

| [' ' '\r' '\n' '\t' '\012'] { token lexbuf }
| "//"[^'\n''\r']*    { token lexbuf }
| "/*"            { comment lexbuf; token lexbuf }
| eof             { EOF }
| _  { BAD_TOKEN }

