open Precompiler.PCTypes;;
open Ast;;


let exportList:cd_symbol list ref = ref [];;
let exportAll:bool ref = ref false;;

let moduleCDHandler (cd:compiler_directive) (x:precompilerInfo):(compiler_directive list * type_decl list * fun_decl list) =
  match cd with
      CDExports l -> exportList := !exportList @ l; ([], [], [])
    | CDExportsAll -> exportAll := true; ([], [], [])
    | CDImport l -> 
	List.fold_left 
	  (fun (cds, types, funcs) filename ->
	     let filename = (match filename with
				 CDSymbol s -> s ^ ".cli"
			       | CDLiteral s -> s) in
	     let file_buf = Cppfilebuf.preprocessed_file_buf_from_filename filename in
	     let lexbuf = Cppfilebuf.lexbuf_from_preprocessed_file_buf file_buf in
	     let p = Parse.program Lex.token lexbuf in
	     let module PC = Precompiler.Make
	       (struct
		  let info = x
		end) in
	     let p' = PC.pc p in
	       ((cds @ p'.program_directives), (types @ p'.program_type_decls), (funcs @ p'.program_fun_decls)))
	  ([], [], [])
	  l
    | _ -> ([], [], [])
;;
 
let moduleFinalizer (p:program) (x:precompilerInfo) =

  let exportFunction (f:fun_decl):fun_decl =
    if f.fun_decl_is_inline then
      { f with fun_decl_stmt = FunNative; fun_decl_is_inline = false }
    else
      { f with fun_decl_stmt = FunNative } in

  if !exportAll then
    let program_fun_decls' = List.map exportFunction p.program_fun_decls in 
    let p' = { program_fun_decls = program_fun_decls'; program_type_decls = p.program_type_decls; program_directives = [] }
    in
      Clayprinter.print_program p' ((Filename.chop_extension (Filename.basename x.pcFilename)) ^ ".cli")
			 
  else if not (!exportList = []) then
    let exportList = List.fold_right
		       (fun x l ->
			  match x with
			      CDSymbol s -> s :: l
			    | CDLiteral _ -> l)
		       !exportList
		       [] in
			      
    let (fcnsExported, program_fun_decls') =
      List.fold_right (fun (f:fun_decl) ((xfnames:string list), (xfs:fun_decl list)) ->
			 if List.mem (fst f.fun_decl_name) exportList then
			   ((fst f.fun_decl_name) :: xfnames, (exportFunction f) :: xfs)
			 else
			   (xfnames, xfs))
	p.program_fun_decls
	([], [])
	
    and (typesExported, program_type_decls') =
      List.fold_right (fun ((tname, typ):type_decl) ((xtnames:string list), (xts:type_decl list)) ->
			 if List.mem (fst tname) exportList then
			   ((fst tname) :: xtnames, (tname, typ) :: xts)
			 else
			   (xtnames, xts))
	p.program_type_decls
	([], [])
	
    in

    let p' = { program_fun_decls = program_fun_decls'; program_type_decls = program_type_decls'; program_directives = [] }

    in
      
      List.iter (fun s -> 
		   if (List.mem s fcnsExported) || (List.mem s typesExported) then ()
		   else raise (Precompilation ("Unable to export symbol " ^ s))) exportList;
      Clayprinter.print_program p' ((Filename.chop_extension (Filename.basename x.pcFilename)) ^ ".cli")
  else
    ()
;;
