/**
 * Omega_Test
 *
 * Assumptions:
 * Omega lib can only add Atomic of EQ and IEQ when under AND
 * So we add and if it does not already exist.
 *
 * @author Edward Wei, Heng Huang, Lea Wittie
 */

#include <iostream>
#include <omega.h> // F_And etc..
#include <config.h> // Lea, it wasn't finding intnat

#if 0
#  include <stlport/hash_map>
#endif

#include <map>

// using std::hash_map;

using std::map;

// This is pretty much an unavoidable hack
// because ml conflicts with omega
namespace ml {
    extern "C" {
#include <mlvalues.h> // was <mlvalues.h> -- Lea
#include <memory.h> // CAMLreturn
    }
};

using ml::local_roots;
using ml::caml__roots_block;
using ml::mlsize_t;
using ml::header_t;

#undef DEBUG
//#define LeaDEBUG


#ifdef ARCH_LITTLEENDIAN
#define value ml::value
#endif

//#undef Field
//#define Field(x, i) (((ml::value*)(x))[i])


// TEMPORARY HACK FOR A LITTLE ENDIAN PC (in mlvalues.h)

#define Tag_val(val) (((unsigned char *) (val)) [-sizeof(value)])


void formula_construct(Relation *R, F_Forall *F_forall, Formula *F, value formula);

enum formula { Atomic, And, Or, Not, Implies, Forall, Exists };
enum atomic { Equality, Inequality, Stride };

/*  gm: attempting to replace non-standard hash_map with standard map.
    struct eqstr
    {
    bool operator()(const char* s1, const char* s2) const
    {
    return strcmp(s1, s2) == 0;
    }
    };


    static hash_map<const char*, Variable_ID, std::hash<const char*>, eqstr> *variableHashMap;

*/

struct ltstr {
    bool operator()(const char* s1, const char* s2) const {
	return strcmp(s1, s2) < 0;
    }
};

static map<const char*, Variable_ID, ltstr> *variableHashMap;


/**
 * stub function called by ml.
 *
 * formula is concrete type w/ tag of constructor val.
 * field 0 is ml::value of constructor argument.

 * The OCaml declaration
 *     external presburger : Arith.cformula -> bool = "presburger"
 * says this function is named pressburger and takes one param, 
 * a cformula, and returns one value, a bool.
 */
extern "C" value presburger(value formula) {
/*
caml_local_roots (clr) points to a struct caml_roots_block (crb)
        ____________________
clr---> | crb* next--------|-->null
        | int ntables      |
        | int nitems       |    ___________
        | value* tables[5]-|--> | | | | | |
        --------------------    -----------
*/
    CAMLparam1(formula); // macro in caml/memory.h

/*
 Now, we have a crb with the params (one param in this case) in its tables
        ____________________                  ____________________
clr---> | crb* next -------|----------------> | crb* next--------|-->null
        | int ntables    1 |                  |                  |
        | int nitems     1 |    ___________   |                  |    ___________
        | value* tables[5]-|--> | | | | | |   |                 -|--> | | | | | |
        --------------------    -|---------   --------------------   ------------
	                         V                         ^
                                 ____        local_frame --|
                         formula |  |
                                 ----
*/
    /*Relation S(1);
      F_Forall* F_forall = S.add_forall();
      F_forall->declare("N");
      F_forall->declare("K");
      S.print();*/
    /*F_And *F_and = S.add_and();
      EQ_Handle eq = F_and->add_EQ();
      eq.update_const(1);

      if (S.is_satisfiable())
      cout << "S is Satisfiable";*/

/* A Relation is a class in Relation.c. This makes one and tells it the count
 * is 1. A relation has a body. The body is a Formula and has a reference 
 * count (num params). (note: _is_set is initially false)  */
    Relation R(1);

/* Add a forall to the body and return the forall (it's a Formula function) */
    F_Forall *F_forall = R.add_forall();

    // should add variables somewhere here
	
    assert(R.is_set()); // tests if the body is set..dont see how it could be
/* old code:
 variableHashMap = new hash_map<const char*, Variable_ID, std::hash<const char*>, eqstr>();
*/

/* a map from strings to Variable_IDs. It uses the less_than string comparison
   function */
    variableHashMap = new map<const char*, Variable_ID, ltstr>();

#ifdef LeaDEBUG
    cout << "Constructing Omega Relation... \n";
#endif

    formula_construct(&R, F_forall, F_forall, formula);

    R.finalize();
//	cout << "\n\nEqu:";
//	R.print();

// TODO: free up the variableHashMap
// CKH: you mean, like this?
    delete variableHashMap; // remove ^M -- Lea

	// ERIC: I changed this from R.is_satisfiable because if it only one
	// bound is satisfiable, rather then evaluating to false it will assert
	if (R.is_upper_bound_satisfiable() && R.is_lower_bound_satisfiable()) {
#ifdef DEBUG
	    cout << "==> satisfiable\n\n";
#endif
	    CAMLreturn (Val_int(1));
/* The return macro points clr back at the original crb (local_frame)
   and returns the value
*/ 
	} else {
#ifdef DEBUG
	    cout << "==> unsatisfiable\n\n";
#endif
	    CAMLreturn (Val_int(0));
	}
										  }


void linear_arith_construct(Relation *R, F_Forall *F_forall, Constraint_Handle* C, value linear_arith) {

#ifdef LeaDEBUG
    cout << "In linear_arith_construct, linear arith: " << linear_arith << endl;
    // BusError if we ask for the size
#endif
    // TODO: assert size
    /*cout << "\n Linear Arith" << linear_arith 
      << " size " << Wosize_val(linear_arith);*/

    // the clinear_arith will be a list

    value variableNode = Field(linear_arith, 0);

    while (variableNode != 1) {

	// data is a tuple var * int
	value data = Field(variableNode, 0);
	// size should be 2
		
	coef_t coeff = String_val(Field(data, 0));
	char* variable = String_val(Field(data, 1));

#ifdef DEBUG
	cout << coeff << "* x" << variable << " + ";
#endif

	// TODO: don't know where I can free this up

	if (variableHashMap->count(variable) == 0) {

#ifdef DEBUG
	    cout << " New Free_Var " << variable << "\n";
#endif

	    Variable_ID globalVar = F_forall->declare(variable);
	    //Free_Var_Decl *globalVar = new Free_Var_Decl(variable);
	    (*variableHashMap)[variable] = globalVar;
	}

	//Variable_ID R_globalVar = R->get_local((*variableHashMap)[variable]);
	C->update_coef((*variableHashMap)[variable], coeff);

	variableNode = Field(variableNode, 1);
    }
	
    coef_t constant = String_val(Field(linear_arith, 1));
#ifdef DEBUG
    cout << constant;
#endif

    C->update_const(constant);
}


void atomic_construct(Relation *R, F_Forall *F_forall, F_And *F, value atomic) {

    // TODO: assert size
    int tag = Tag_val(atomic);

#ifdef LeaDEBUG
    if (F == NULL) cout << "why is F null?\n";
    cout << "In Atomic construct, got tag. Atomic: " << atomic
	 << " size: " << Wosize_val(atomic) << " tag: " << tag << endl;
#endif

    switch (tag) {
    case Equality: {

#ifdef LeaDEBUG
	cout << "\tAdding EQ\n";
#endif
	EQ_Handle F_eq = F->add_EQ();

	value linear_arith = Field(atomic, 0);

	linear_arith_construct(R, F_forall, &F_eq, linear_arith);

#ifdef LeaDEBUG
	cout << " == 0\n";
#endif
	break;
    }
    case Inequality: {
	// something >= 0
	//
#ifdef LeaDEBUG
	cout << "\t%%Adding ineq>\n";
#endif

	// quirky syntax different from Formula->add
	GEQ_Handle F_ieq = F->add_GEQ();
		
	value linear_arith = Field(atomic, 0);
	linear_arith_construct(R, F_forall, &F_ieq, linear_arith);

#ifdef LeaDEBUG
	cout << " >= 0\n";
#endif
	break;
    }
    case Stride:

#ifdef LeaDEBUG
	cout << "\tStride Atomic\n";
#endif
	break;
    default:

#ifdef LeaDEBUG
	cout << "\tUnkown Atomic\n";
#endif
	return;
    }
}

/* Called with (*R, *Forall, *Forall, formula) so F_Forall and F start out the
   same. */
void formula_construct(Relation *R, F_Forall *F_forall, Formula *F, value formula) {

    int constructor_tag = Tag_val(formula);

    //value arguments = Code_val(arguments);
    /*cout << "\n\nformula: " << formula
      << ":" << Wosize_val(formula) 
      << "\nConstructor Tag: " << constructor_tag;*/
    //	<< "\nPtrArg Field " << ptr_arg;
    /*	<< "@" << Tag_val(ptr_arg);*/
    //<< ":" << Wosize_val(ptr_arg);
#ifdef LeaDEBUG
    cout << "In formula_construct, formula: " << formula 
	 << " size: " <<  Wosize_val(formula) 
	 << " tag: " << constructor_tag << endl;

/*    int i;
    for (i=0; i<Wosize_val(formula); i++) {
	value subfield = Field(formula,i);
	int subtag = Tag_val(subfield);
	cout << "\tField " << i << ", size: " << Wosize_val(Field(formula,i));
	cout << ", tag: " << subtag;
    }
    cout << endl; */
#endif

    switch(constructor_tag) {

    case Atomic: { // a1*x1 + ... + an*xn + a0 ?= 0 
#ifdef LeaDEBUG
	cout << "\tAtomic tag: a1*x1 + ... + an*xn + a0 ?= 0\n";
#endif
	// only F_And's may have Atomics
	F_And* F_and = dynamic_cast<F_And*>(F);
#ifdef LeaDEBUG
	if (F_and == NULL) cout << "\t\tAdding AND\n"; 
#endif
	if (F_and == NULL)
	    F_and = F->add_and();

	atomic_construct(R, F_forall, F_and, Field(formula,0));
	break;
    }

    case Implies: {// P => Q  is equivalent to (not P) or Q
#ifdef LeaDEBUG
	cout << "\tImplies tag: P => Q\n";
#endif	
	value formula_P = Field(formula,0);
	int tag_P = Tag_val(formula_P);
	value formula_Q = Field(formula,1);
	int tag_Q = Tag_val(formula_Q);

#ifdef LeaDEBUG
	cout << "\t\tforumula_P" << formula_P 
	  << " tag: " << tag_P
	  << " size: " << Wosize_val(formula_P) << endl;
	  cout << "\t\tforumula_Q" << formula_Q 
	  << " tag: " << tag_Q
	  << " size: " << Wosize_val(formula_Q) << endl;
#endif

	F_Or *R_imp = F->add_or();
#ifdef LeaDEBUG
	cout << "\t\tAdded Or";
#endif

	F_Not *R_P = R_imp->add_not();
#ifdef LeaDEBUG
	cout << "\tAdded Not";
	cout << "\tDoing P\n";
#endif

	formula_construct(R, F_forall, R_P, formula_P);

#ifdef LeaDEBUG
	cout << "Back in Implies\tConstructed P";
	cout << "\tDoing Q\n";
#endif

	formula_construct(R, F_forall, R_imp, formula_Q);

#ifdef LeaDEBUG
	cout << "Back in Implies\tConstructed Q\n";
#endif
	break;
    }
    case And: {

	/*if (argument_size != 1)
	  cerr << "ERROR: Malformed arguments to constructor "
	  << argument_size << endl;
	  cout << "Argument contains: " << arguments << ":"
	  << argument_size << endl;*/

	F_And *F_and = F->add_and();

#ifdef LeaDEBUG
	cout << "%%Adding And>";
#endif
			
	// " sees a list: ";
	value listnode = Field(formula,0);

	while (listnode != 1) {
	    // cout << "\n" << listnode; // << ":" << Wosize_val(listnode);
	    value data = Field(listnode, 0);
	    // cout << " data: " << data;
	    formula_construct(R, F_forall, F_and, data);
	    listnode = Field(listnode, 1);
	}
	break;
    }
    case Or: {

	F_Or *F_or = F->add_or();

#ifdef LeaDEBUG
	cout << "%%Adding Or>";
#endif

	// " Or takes a list "
	value listnode = Field(formula,0);

	while (listnode != 1) {
	    // cout << "\n" << listnode; // << ":" << Wosize_val(listnode);
	    value data = Field(listnode, 0);
	    // cout << " data: " << data;
	    formula_construct(R, F_forall, F_or, data);
	    listnode = Field(listnode, 1);
	}
	break;
    }
    case Not: {

	F_Not *F_not = F->add_not();

	// formula Size should be 1

	value notform = Field(formula, 0);
	formula_construct(R, F_forall, F_not, notform);
			
	break;
    }
    case Forall: {

#ifdef LeaDEBUG
	cout << "See Forall\n";
#endif
	break;
    }
    case Exists: {

#ifdef LeaDEBUG
	cout << "See Exists\n";
#endif
	break;
    }
    default:

#ifdef LeaDEBUG
	cout << "See Unkown\n";
#endif
	return;
    }
}
