/* 
 * Laddie to Clay Compiler
 * Author: Lea Wittie and Derrin Pierret
 * Copyright (c) 2007 Bucknell University
 *
 * Permission is hereby granted, free of charge, to any individual or
 * institution obtaining a copy of this software and associated
 * documentation files (the "Software"), to use, copy, modify, and
 * distribute without restriction, provided that this copyright and
 * permission notice is maintained, intact, in all copies and supporting
 * documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL BUCKNELL UNIVERSITY BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef GENERATE_H_
#define GENERATE_H_

#include<vector>
#include<fstream>

class Generate {
 public:
  Generate();
  void walkTree(TreeNode* nodePtr);
  void treeError(char* error);
 private:

  //void treeError(char* error);
  void driver(TreeNode* nodePtr);

  // ---------------- Tests -------------------
  void makeTest();
  void makeConsistency(string rw);
  void makeConsistencyChecker();

  // ---------------- IO rules ---------------------------
  void ports(TreeNode* nodePtr);
  void port(TreeNode* nodePtr);
  void port_info(TreeNode* nodePtr);
  void makeRead();
  void makeWrite();

  // The constraint trees - generate environment, print constraints
  void before_opt(TreeNode* nodePtr);
  void after_opt(TreeNode* nodePtr);
  void before(TreeNode* nodePtr);
  void after(TreeNode* nodePtr);
  void constraints(TreeNode* nodePtr);
  void switch_cases(TreeNode* nodePtr);
  void switch_case(TreeNode* nodePtr);
  void default_case_opt(TreeNode* nodePtr);
  void transitions(TreeNode* nodePtr);
  void logic_list(TreeNode* nodePtr);
  void logic_OR(TreeNode* nodePtr);
  void logic_AND(TreeNode* nodePtr);
  void logic_NOT(TreeNode* nodePtr);
  void logic_end(TreeNode* nodePtr);
  void rel_exp(TreeNode* nodePtr);
  void relop(TreeNode* nodePtr);
  void add_exp(TreeNode* nodePtr);
  void addop(TreeNode* nodePtr);
  void mul_exp(TreeNode* nodePtr);
  void exp_end(TreeNode* nodePtr);
  void id(TreeNode* nodePtr, string ending);

  // General helper functions
  void resetPortInfo();

  // Output helper functions
  void createIOReadFunction();
  void createNativeReadFunction();
  void createIOWriteFunction();
  void createNativeWriteFunction();
  void createIORepeatedFunction(int rw);
  void addIOCommand(string s);
  void createMacro(string io);
  string ioFunctionName(string rw, int size, bool b);

  // Print specific parts of the output 
  // (n is a part count so we know when to use \n)
  int printGlobalStateConstraints(int n); // B <= 3
  int printOneConstraints(SemanticRec* currRec, string letter, int n);
  void createFunctionName(string rw, fstream & out);
  int createStateTypes(int n);     // windowState[D,B0]
  int createStateDecls(int n);     // u1 A0, u32 B0
  int createStateParams(int n);    // windowState[D,B0] window
  int createFieldTypes(int n);         // Int[F]
  int createFieldDecls(int n);     // u3 F0, u2 G0, u8 H0
  int createFieldParams(int n);    // Int[B0] one
  bool otherPreserves(string field);
  void createEnumConstraints();

  // interract with vectors
  int getFieldSize(string key);
  int getStateSize(string key);
  string getFieldLetter(string key);
  string getStateLetter(string key);
  void setUsedState(string key);
  void setChangedState(string key);
  string getStateType(string s);
  string getStateVar(string s);

  // scope
  SymbolTable* scope;

  // The output files
  fstream outNative; // C++ IO functions
  fstream outFunction; // Clay IO function headers
  fstream outMacro; // Clay IO macros

  fstream outDefines; // if needed
  fstream outTest; // Clay test file to check spec consistency
  fstream outMain; // C++ main file to check that Clay test compiles ok
  fstream outNativeIO; // for translation test extern C++ IO calls

  // for states
  int stateCount;               // # of constrained states
  vector<string> stateNames;    // names of the constrained states
  vector<int> stateSizes;       // sizes (1,32) of the states
  vector<string> stateLetters;

  SymbolTable* IOCommands;
  ClayNameGen currName;
  SemanticRec* currPort;

  // Generation Helpers
  TreeNode* beforeTree;           // The start of a before_opt subtree
  TreeNode* afterTree;            // The start of an after_opt subtree
  string io;                      // "In" or "Out"
  int mode;                       // read_write__1 (r) 2 (w) 3 (rw)
  bool env;                       // Are we in environment building or printing

  // Port variables
  int fieldCount;                   // # of fields in a port
  vector<string> fieldNames;    // names of the constrained states
  vector<int> fieldSizes;       // sizes (1,32) of the states
  vector<string> fieldLetters;
  string switchName;
  bool wereSwitchCases;
  vector<bool> usedStates;
  vector<bool> changedStates;
  int optCnt;

  
  // Test variables
  string cons_constraint;
};

#endif
