/* 
 * Laddie to Clay Compiler
 * Author: Lea Wittie and Derrin Pierret
 * Copyright (c) 2007 Bucknell University
 *
 * Permission is hereby granted, free of charge, to any individual or
 * institution obtaining a copy of this software and associated
 * documentation files (the "Software"), to use, copy, modify, and
 * distribute without restriction, provided that this copyright and
 * permission notice is maintained, intact, in all copies and supporting
 * documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL BUCKNELL UNIVERSITY BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef SEMANTICS_H_
#define SEMANTICS_H_

// This class does a walk of the parse tree
class Semantics {
 public:
    void treeError(char* error);
  Semantics();
  void walkTree(TreeNode* nodePtr);
 private:
  void driver(TreeNode* nodePtr);

  // ---------------- Device State -----------------------
  void states_opt(TreeNode* nodePtr);
  void states(TreeNode* nodePtr);
  void state(TreeNode* nodePtr);

  // ---------------- IO rules ---------------------------
  void ports(TreeNode* nodePtr);

  void field_list_opt(TreeNode* nodePtr);
  void field_list(TreeNode* nodePtr);
  void field_info(TreeNode* nodePtr);
  void field_attribs(TreeNode* nodePtr);

  void num_or_set(TreeNode* nodePtr, SemanticRec* currRec);
  void constraint_set(TreeNode* nodePtr, SemanticRec* currRec);

  void port(TreeNode* nodePtr);
  void port_info(TreeNode* nodePtr, int portNum);
  void name_info(TreeNode* nodePtr);
  void size_info_opt(TreeNode* nodePtr);  
  void type_info_opt(TreeNode* nodePtr);
  void access_info_opt(TreeNode* nodePtr);
    
  void read_attrib_opt(TreeNode* nodePtr);
  void write_attrib_opt(TreeNode* nodePtr);
  void write_attrib(TreeNode* nodePtr);
  void enum_opt(TreeNode* nodePtr);
  void enum_list(TreeNode* nodePtr);
  void enum_val(TreeNode* nodePtr);

  void before_opt(TreeNode* nodePtr);
  void before(TreeNode* nodePtr);
  void after_opt(TreeNode* nodePtr);
  void after(TreeNode* nodePtr);
  void constraints(TreeNode* nodePtr);

  void switch_cases(TreeNode* nodePtr);
  void switch_case(TreeNode* nodePtr);
  void default_case_opt(TreeNode* nodePtr);
 
  void transitions(TreeNode* nodePtr);
  void logic_list(TreeNode* nodePtr);
  void logic_OR(TreeNode* nodePtr);
  void logic_AND(TreeNode* nodePtr);
  void logic_NOT(TreeNode* nodePtr);
  void logic_end(TreeNode* nodePtr);
  void rel_exp(TreeNode* nodePtr);
  void relop(TreeNode* nodePtr);
  void add_exp(TreeNode* nodePtr);
  void addop(TreeNode* nodePtr);
  void mul_exp(TreeNode* nodePtr);
  void exp_end(TreeNode* nodePtr);

  // consistency tests
  void test_opt(TreeNode * nodePtr);
  void test_list(TreeNode * nodePtr);
  void test(TreeNode * nodePtr);

  // scope
  void pushScope();
  void popScope();
  SymbolTable* scope;      // current scope

  // for States

  // for IO rules
  int enum_value; // next available value in an enum
  int reservedCount;
  bool doBitsConflict(SemanticRec* newRec, SemanticRec* currRec);
  double maxBitValue(SemanticRec* currRec);
  bool nameExists(string name, vector<string> & names);
  bool isPortUnique();

  int errCount;
  string io;               // before or after (pre/post condition)
  int mode;                // condition for read/write/readwrite
  SemanticRec* currPort;   // current port 
  SemanticRec* currField; // current field within the port
  SemanticRec* currSwitch; // current switch within the port
  Boundary* usedSwitchValues;
  vector<string> usedSwitchNames;
  vector<string> usedPortNames;

  // for consistency testing

};

#endif
