#ifndef _COMPILER_H
#define _COMPILER_H

#include <stdio.h>
#include "support.h"

// The parser forms a parse tree

#define M 11 // width of the hash table
// Parse Tree node.
class TreeNode {
public:
    TreeNode();
    TreeNode(int kind);
    TreeNode(int kind, int lineno);
    ~TreeNode();
    int    kind;   // From the enum above (e.g. prog1)
    int    numval; // If it holds a number, its value
    string strval; // If it holds an id, its name
    int    line;   // Line number in the code
    TreeNode* ptr1;  // Child node 1
    TreeNode* ptr2;  // Child node 2
    TreeNode* ptr3;  // Child node 3
    TreeNode* ptr4;  // Child node 4
    TreeNode* ptr5;  // Child node 5
    TreeNode* ptr6;  // Child node 6
    TreeNode* ptr7;  // Child node 7
    TreeNode* ptr8;  // Child node 8
    SymbolTable*  symTabPtr;
};

// The kinds in the parse tree
enum {driver__1, num__1, num__2, num_or_set__1, num_or_set__2, num_or_range__1, num_or_range__2, num_or_range__3, type__1, type__2, constraint_set__1, constraint_set__2, num_or_bool__1, num_or_bool__2, id_or_value__1, id_or_value__2, states_opt__1, states_opt__2, states__1, states__2, state__1, state__2, ports__1, ports__2, port__1, port_info__1, name_info__1, size_info_opt__1, size_info_opt__2, type_info_opt__1, type_info_opt__2, access_info_opt__1, access_info_opt__2, read_write__1, read_write__2, read_write__3, field_list_opt__1, field_list_opt__2, field_list__1, field_list__2, field_info__1, colon_opt__1, colon_opt__2, field_attribs__1, write_attrib_opt__1, write_attrib_opt__2, write_attrib__1, write_attrib__2, read_attrib_opt__1, read_attrib_opt__2, read_attrib__1, read_attrib__2, enum_opt__1, enum_opt__2, enum_list__1, enum_list__2, enum_val__1, enum_val__2, before_opt__1, before_opt__2, before__1, before__2, before__3, before__4, after_opt__1, after_opt__2, after__1, after__2, after__3, after__4, constraints__1, constraints__2, switch_cases__1, switch_cases__2, switch_case__1, switch_case__2, default_case_opt__1, default_case_opt__2, transitions__1, transitions__2, logic_list__1, logic_list__2, logic_OR__1, logic_OR__2, logic_AND__1, logic_AND__2, logic_NOT__1, logic_NOT__2, logic_end__1, logic_end__2, rel_exp__1, relop__1, relop__2, relop__3, relop__4, relop__5, relop__6, add_exp__1, add_exp__2, addop__1, addop__2, mul_exp__1, mul_exp__2, exp_end__1, exp_end__2, exp_end__3, exp_end__4, exp_end__5, exp_end__6, exp_end__7, test_opt__1, test_opt__2, test_list__1, test_list__2, test__1};

extern TreeNode* parseTree;
extern int lineno;

#endif
