/* 
 * Laddie to Clay Compiler
 * Author: Lea Wittie and Derrin Pierret
 * Copyright (c) 2007 Bucknell University
 *
 * Permission is hereby granted, free of charge, to any individual or
 * institution obtaining a copy of this software and associated
 * documentation files (the "Software"), to use, copy, modify, and
 * distribute without restriction, provided that this copyright and
 * permission notice is maintained, intact, in all copies and supporting
 * documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL BUCKNELL UNIVERSITY BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
using namespace std;

#include<iostream>
#include<string>
#include"compiler.h"
#include"morekinds.h"
#include"support.h"
#include "Treewalk.h"
#include"Semantics.h"
#include"Generate.h"

TreeNode* parseTree;
int yyparse(void);
string fname;
bool consistency;
bool translation;

bool testflag(string str) {
  if (str=="-all" || str=="-a") {
    consistency=true;
    translation=true;
    return true;
  }
  if (str=="-consistency" || str=="-c") {
    consistency = true;
    return true;
  }
  if (str=="-translation" || str=="-t") {
    translation = true;
    return true;
  }
  return false;
}

int main(int argc, char* argv[]){
  cout << "Laddie version 1.0\n";

  // argv[0] is the name of the program (by convention)
  // argv[1] would be the file name

  // if flags, handle them
  int i; for(i=1; i<=argc && testflag(argv[i]); i++);
    
  if (i>argc) {
    cout << "LADDIE: no input files\n";
    exit(1);
  }

  yyin = fopen(argv[i], "r");
  fname = argv[i];
  fname = fname.substr(0, strlen(argv[i])-4);
 
  yyparse();
  fclose(yyin);

  cout << "Testing tree formation...\n";
  Treewalk testing;
  testing.walkTree(parseTree);
  
  cout << "Static semantic checks...\n";
  Semantics theTree;
  theTree.walkTree(parseTree);

  cout << "Code generation...\n";
  Generate codeMaker;
  codeMaker.walkTree(parseTree);
  
  return 0;
}
