/* 
 * Laddie to Clay Compiler
 * Author: Lea Wittie and Derrin Pierret
 * Copyright (c) 2007 Bucknell University
 *
 * Permission is hereby granted, free of charge, to any individual or
 * institution obtaining a copy of this software and associated
 * documentation files (the "Software"), to use, copy, modify, and
 * distribute without restriction, provided that this copyright and
 * permission notice is maintained, intact, in all copies and supporting
 * documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL BUCKNELL UNIVERSITY BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef SUPPORT_H_
#define SUPPORT_H_

using namespace std;
#include<iostream>
#include<string>
#include<vector>
#define M 11    // Max HashTable size...

/* Semantic Record node for a variable or a function.
 * The type semRec is a union of two structures
 * Union means the semRec is either a v (variable) or f (function)
 * It is accessed as if the union has two members v and f except that you may
 * only access one of them. Example: semRec sr; sr.v.kind = intvar;
 * The type checker *should* notice if you try to use it as both v and f.
 */

extern string fname;
extern bool consistency;
extern bool translation;

string itoa(int number);
unsigned int genReadMask(int startBit, int finishBit);
unsigned int genWriteMask(int startBit, int finishBit);

class ClayNameGen {
public:
    ClayNameGen();
    void genNextName();
    string getCurrName();
    void reset();
private:
    int currChar;
    int currNumber;
};

class Range {
public:
    Range();
    Range(int inLow, int inHi);
    bool isInRange(int value);
    void setRange(int inLow, int inHi);
    int getHigh();
    int getLow();
    bool isNull();
private:
    int hi;
    int low;
};

class Boundary {
public:
    Boundary();
    void add(int num1);
    void add(int num1, int num2);
    bool isInBounds(int value);
    bool isEmpty();
    Range getRange(int index);
    int getSize();
private:
    vector<Range> set;
};

class SemanticRec {
public:
    SemanticRec(int inKind, int inLine);
    SemanticRec(int inKind, int inLine, string inKey);
    ~SemanticRec();
    string key;          // key to use for insert and lookup
    int kind;            // PORTINFO, STATEINFO, FIELDINFO, ENUMINFO...
    int line;            // code line number

    // port
    int userDefinedValue; // value of a user defined ID
    string name;      // "status port"
    int access;       // Access of port (read_write__ 1 or 2 or 3)
    vector<string> ids; // ids in test input (consistency testing)
    vector<int> values; // values in test input (consistency testing)
    int length;         // number of inputs to the consistency test.

    // port and struct
    int num;          // number of port (address) OR number of struct fields
    int size;         // Size of port  (in bytes) OR size of struct

    // struct    
    vector<int> structfields; // size of each field in the struct

    // state
    int lineDefined;      // aka window = 3; DO WE USE THIS?
    int type;  // boolean or integer

    // field
    int write_attrib;     // 0 == none, write_attrib__1 == fixed(num)
                          // write_attrib__2 == preserve
    int write_num;        // value to write when fixed

    // state and field
    Boundary range;          // the allowed values it can have
};

enum {PORTINFO, STATEINFO, FIELDINFO, ENUMINFO, STRUCTINFO};


// HashNode. Points to a semantic record.
class HashNode {
public:
    HashNode();
    ~HashNode();
    string       key;             // Variable or function name
    SemanticRec* theSemRec;       // The semantic record.
    HashNode*   nextNode;
};

// Symbol Table. Contains a hash table of all the semantic 
// records in its scope.
class SymbolTable {
public:
    SymbolTable();
    ~SymbolTable();
    void insert(SemanticRec* theRec);
    void insert(string theName, SemanticRec* theRec);
    SemanticRec* lookup(string theName);
    SymbolTable* prevScope;  // Pointer to previous scope
    void startIterator();
    bool moreToIterate();
    SemanticRec* nextIteratedSR();
private:
    int hashFunct(string theName);
    HashNode*    theTable[M];// Pointer to this scope's semantic records
    int       currentSlot;  // for the iterator
    HashNode* currentHN; // for the iterator

};


#endif
